<?php
/* /lib/script/admin_init.php */
if (!defined('ABSPATH')) {
    exit;
}

function webcheckups_admin_body_class($classes): string
{
    $screen = get_current_screen();

    $plugin_pages = [
        'toplevel_page_website_checkups_menu',
        'website-checkups_page_notifications_menu',
        'website-checkups_page_checkups_menu',
        'website-checkups_page_checkup_results_menu',
        'website-checkups_page_dashboard_menu',
    ];

    if ($screen && in_array($screen->id, $plugin_pages)) {
        $classes .= webcheckups_plugin_prefix;
    }

    return $classes;
}

add_filter('admin_body_class', 'webcheckups_admin_body_class');
function webcheckups_admin_style_script(): void
{
    $default_data = [
        'site_url'     => webcheckups_site_url,
        'api_loc'      => webcheckups_api_loc,
        'nonce'        => wp_create_nonce(webcheckups_admin_nonce),
        'template_loc' => webcheckups_lib_dir_url . 'template/',
        'page_class'   => get_current_screen()->id,
        'plugin_version' => '1.2.0', // Für Cache-Invalidierung
        'user_data'    => [
            'token'        => webcheckups_get_token_from_db(),
            'mail'         => wp_get_current_user()->user_email,
            'first_name'   => wp_get_current_user()->first_name,
            'last_name'    => wp_get_current_user()->last_name,
            'site_address' => webcheckups_site_url,
            'site_lang'    => substr(get_bloginfo('language'), 0, 2),
        ],
    ];

    $plugin_pages = [
        'toplevel_page_website_checkups_menu',
        'website-checkups_page_notifications_menu',
        'website-checkups_page_checkups_menu',
        'website-checkups_page_checkup_results_menu',
        'website-checkups_page_dashboard_menu',
    ];

    if (in_array($default_data['page_class'], $plugin_pages)) {
        if ($default_data['page_class'] == 'website-checkups_page_checkup_results_menu' ||
            $default_data['page_class'] == 'website-checkups_page_dashboard_menu') {
            wp_enqueue_style(
                webcheckups_plugin_prefix . '-slick-css',
                webcheckups_lib_dir_url . 'css/slick.css',
                [],
                '1.9.0'
            );
            wp_enqueue_script(
                'chart-js-npm',
                webcheckups_lib_dir_url . 'js/chart-js.min.js',
                ['jquery'],
                '4.5.0',
                true
            );
            wp_enqueue_script(
                webcheckups_plugin_prefix . '-chart-js',
                webcheckups_lib_dir_url . 'js/charts.js',
                [],
                '1.2.0',
                true
            );
            wp_enqueue_script('slick-js', webcheckups_lib_dir_url . 'js/slick.min.js', [], '1.8.1', true);
        } elseif ($default_data['page_class'] == 'website-checkups_page_checkups_menu') {
            wp_enqueue_script(
                webcheckups_plugin_prefix . '-mask-js',
                webcheckups_lib_dir_url . 'js/jquery.mask.min.js',
                ['jquery'],
                '1.14.16',
                true
            );
        }

        wp_enqueue_style(
            webcheckups_plugin_prefix . '-bootstrap-css',
            webcheckups_lib_dir_url . 'css/bootstrap.css',
            [],
            '5.3.8'
        );
        wp_enqueue_style(webcheckups_plugin_prefix . '-css', webcheckups_lib_dir_url . 'css/admin.css', [], '1.2.0');

        wp_enqueue_script(
            webcheckups_plugin_prefix . '-bootstrap-js',
            webcheckups_lib_dir_url . 'js/bootstrap.js',
            [],
            '5.3.8',
            true
        );
        // Load API layer first (refactored from admin.js)
        wp_enqueue_script(
            webcheckups_plugin_prefix . '-api-js',
            webcheckups_lib_dir_url . 'js/api.js',
            [],
            '1.2.0',
            true
        );
        wp_enqueue_script(
            webcheckups_plugin_prefix . '-cache-statistics',
            webcheckups_lib_dir_url . 'js/cache-statistics.js',
            array(webcheckups_plugin_prefix . '-api-js'),
            '1.2.0',
            true
        );
        wp_enqueue_script(
            webcheckups_plugin_prefix . '-ui-js',
            webcheckups_lib_dir_url . 'js/ui-helpers.js',
            [],
            '1.2.0',
            true
        );
        wp_enqueue_script(
            webcheckups_plugin_prefix . '-stat-js',
            webcheckups_lib_dir_url . 'js/statistics.js',
            [],
            '1.2.0',
            true
        );
        wp_enqueue_script(
            webcheckups_plugin_prefix . '-cal-js',
            webcheckups_lib_dir_url . 'js/calendar.js',
            [],
            '1.2.0',
            true
        );
        wp_enqueue_script(
            webcheckups_plugin_prefix . '-js',
            webcheckups_lib_dir_url . 'js/admin.js',
            [],
            '1.2.0',
            true
        );
        wp_localize_script(webcheckups_plugin_prefix . '-api-js', webcheckups_plugin_prefix . '_code', $default_data);
    } else {
        wp_enqueue_style(
            webcheckups_plugin_prefix . '-hide-menu',
            webcheckups_lib_dir_url . 'css/hidemenu.css',
            [],
            '1.2.0',
        );
    }
}

add_action('admin_enqueue_scripts', 'webcheckups_admin_style_script');
