<?php

/*
 * Plugin Name: Website Checkups
 * Plugin URI: https://website-checkups.com/
 * Description: Stay informed about the "health" of your webservices or other complex web infrastructures. Monitoring multiple sites & services 24/7
 * Contributors: webcheckups
 * Version: 1.2.0
 * Requires at least: 5.6
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * Author: elpix GmbH
 * License: GPLv2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

if (!defined('ABSPATH')) {
    exit;
}

const webcheckups_site_url = 'https://api1.website-checkups.com';
const webcheckups_api_loc = webcheckups_site_url.'/api/v1/';
const webcheckups_plugin_prefix = 'website_checkups';

const webcheckups_admin_nonce = 'admin_nonce';

// Plugin Activation Hook
register_activation_hook(__FILE__, 'webcheckups_plugin_activate');

function webcheckups_plugin_activate() {
    webcheckups_update_field_definitions();
}

// Plugin Update Hook (bei Version-Änderung)
add_action('upgrader_process_complete', 'webcheckups_plugin_update', 10, 2);
function webcheckups_plugin_update($upgrader_object, $options) {
    if ($options['action'] == 'update' && $options['type'] == 'plugin') {
        foreach ($options['plugins'] as $plugin) {
            if ($plugin == plugin_basename(__FILE__)) {
                webcheckups_update_field_definitions();
            }
        }
    }
}

$webcheckups_form_fields = [];

define('webcheckups_root_dir_path', plugin_dir_path(__FILE__));
define('webcheckups_root_dir_url', plugin_dir_url(__FILE__));

const webcheckups_lib_dir_path = webcheckups_root_dir_path . 'lib/';
const webcheckups_lib_dir_url  = webcheckups_root_dir_url . 'lib/';

include_once 'lib/script/admin_init.php';
include_once 'lib/script/manage_data.php';

add_action('admin_menu', 'webcheckups_plugin_menu');
function webcheckups_plugin_menu(): void
{
    add_menu_page(
        'Website Checkups',
        'Website Checkups',
        'manage_options',
        webcheckups_plugin_prefix . '_menu',
        function () {
            webcheckups_page('setting', 'setting', false);
        },
        'dashicons-search',
        20
    );

    add_submenu_page(
        webcheckups_plugin_prefix . '_menu',
        'Settings',
        'Settings',
        'manage_options',
        webcheckups_plugin_prefix . '_menu',
    );

    add_submenu_page(
        webcheckups_plugin_prefix . '_menu',
        'Notifications',
        'Notifications',
        'manage_options',
        'notifications_menu',
        function () {
            webcheckups_page('notifications', 'notifications', true);
        }
    );

    add_submenu_page(
        webcheckups_plugin_prefix . '_menu',
        'Checkups',
        'Checkups',
        'manage_options',
        'checkups_menu',
        function () {
            webcheckups_page('sitecheckups', 'checkups', true);
        }
    );

    add_submenu_page(
        webcheckups_plugin_prefix . '_menu',
        'Checkup Results',
        'Checkup Results',
        'manage_options',
        'checkup_results_menu',
        function () {
            webcheckups_page('checkup_details', 'checkup results', false);
        }
    );

    add_submenu_page(
        webcheckups_plugin_prefix . '_menu',
        'Dashboard',
        'Dashboard',
        'manage_options',
        'dashboard_menu',
        function () {
            webcheckups_page('dashboard', 'dashboard', false);
        }
    );
}

function webcheckups_page($template_name, $page_title, $show_add_btn): void
{
    $toast_holder_path = file_get_contents(webcheckups_lib_dir_path . '/template/template_toast_holder.html');

    $structure_html_path    = webcheckups_lib_dir_path . 'template/template_structure.html';
    $structure_html_content = file_get_contents($structure_html_path);
    $structure_html_content = str_replace(
        '{{item_name}}',
        implode(' ', explode('_', $template_name)),
        $structure_html_content
    );

    if ($show_add_btn) {
        $structure_html_content = str_replace('{{add_new_item}}', '', $structure_html_content);
        $structure_html_content = str_replace('{{btn_name}}', $page_title, $structure_html_content);
    } else {
        $structure_html_content = str_replace('{{add_new_item}}', 'd-none', $structure_html_content);
    }

    $structure_html_content = str_replace(
        '{{template_data}}',
        webcheckups_page_template($template_name, $show_add_btn),
        $structure_html_content
    );
    $structure_html_content = str_replace('{{toast_holder}}', $toast_holder_path, $structure_html_content);

    $structure = [
        'div' => [
            'class' => [],
            'id' => [],
            'aria-atomic' => [],
            'aria-live' => [],
            'aria-hidden' => [],
            'style' => [],
            'role' => [],
            'tabindex' => [],
            'data-bs-ride' => [],
            'data-bs-backdrop' => [],
        ],
        'h1' => [
            'class' => [],
            'id' => [],
            'style' => [],
        ],
        'h2' => [
            'class' => [],
            'id' => [],
            'style' => [],
        ],
        'h3' => [
            'class' => [],
            'id' => [],
            'style' => [],
        ],
        'h5' => [
            'class' => [],
            'id' => [],
            'style' => [],
        ],
        'strong' => [],
        'a' => [
            'class' => [],
            'data-bs-target' => [],
            'data-bs-toggle' => [],
            'href' => [],
            'id' => [],
            'style' => [],
            'target' => [],
        ],
        'ul' => [
            'class' => [],
        ],
        'li' => [
            'class' => [],
            'role' => [],
        ],
        'button' => [
            'class' => [],
            'aria-label' => [],
            'data-bs-target' => [],
            'data-bs-toggle' => [],
            'data-bs-placement' => [],
            'data-bs-title' => [],
            'data-bs-slide' => [],
            'data-bs-dismiss' => [],
            'data-granularity' => [],
            'role' => [],
            'type' => [],
            'id' => [],
        ],
        'fieldset' => [
            'class' => [],
        ],
        'input' => [
            'class' => [],
            'id' => [],
            'placeholder' => [],
            'type' => [],
            'aria-label' => [],
            'role' => [],
            'value' => [],
        ],
        'textarea' => [
            'class' => [],
            'id' => [],
            'placeholder' => [],
            'style' => [],
        ],
        'label' => [
            'for' => [],
            'class' => [],
        ],
        'span' => [
            'class' => [],
            'aria-hidden' => [],
            'role' => [],
            'id' => [],
            'title' => [],
        ],
        'small' => [
            'class' => [],
            'id' => [],
        ],
        'select' => [
            'class' => [],
            'id' => [],
            'multiple' => [],
        ],
        'option' => [
            'value' => [],
            'selected' => [],
        ],
        'table' => [
            'class' => [],
            'id' => [],
        ],
        'thead' => [],
        'tbody' => [],
        'tr' => [
            'id' => [],
            'data-uid' => [],
            'data-item_uid' => [],
            'data-item_id' => [],
        ],
        'td' => [
            'class' => [],
            'data-tooltip' => [],
        ],
        'p' => [
            'class' => [],
            'id' => []
        ],
        'i' => [
            'class' => [],
        ],
        'th' => [
            'scope' => [],
            'class' => [],
        ],
    ];

    echo wp_kses($structure_html_content, $structure);
}

add_action('admin_enqueue_scripts', 'webcheckups_hide_submenus_by_default');

function webcheckups_hide_submenus_by_default(): void
{
    if (is_admin()) {
        wp_enqueue_style(
            webcheckups_plugin_prefix . '-hide-menu',
            webcheckups_lib_dir_url . 'css/hidemenu.css',
            [],
            '1.2.0',
        );
    }
}
